/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8260.DeviceView;

import ibm.nways.jdm.CompStatusDefault;
import ibm.nways.jdm.CompoundStatus;
import ibm.nways.jdm.GraphicAction;
import ibm.nways.jdm.GraphicComponent;
import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicFlyOver;
import ibm.nways.jdm.GraphicImage;
import ibm.nways.jdm.Status;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm8260.DeviceView.BankLike;
import ibm.nways.jdm8260.DeviceView.DefaultStatus;
import ibm.nways.jdm8260.DeviceView.GrayableLike;
import ibm.nways.jdm8260.DeviceView.HubInfoLike;
import ibm.nways.jdm8260.DeviceView.LateStatusLike;
import ibm.nways.jdm8260.DeviceView.LeafCompositeLike;
import ibm.nways.jdm8260.DeviceView.PortLike;
import ibm.nways.jdm8260.DeviceView.StatusRefLike;
import ibm.nways.ras.RAS;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;

public abstract class Bank
implements BankLike,
GraphicAction,
ActionListener,
LateStatusLike,
GrayableLike {
    private Vector components = new Vector();
    protected Point location;
    protected int slot;
    protected int subSlot;
    protected int bankIndex;
    protected int modType;
    protected int network;
    protected GraphicContainer moduleContainer;
    protected boolean isLogicalView = false;
    protected GraphicImage aggregateImage;
    protected String destinationPanel;
    protected GenModel portModel;
    protected GraphicContainer logicalContainer = new GraphicContainer();
    protected HubInfoLike hub;
    protected String gifName = "gif/connector_telco_12.gif";

    public void dispose() {
        this.portModel = null;
        this.moduleContainer = null;
        if (this.logicalContainer != null) {
            this.logicalContainer.dispose();
            this.logicalContainer = null;
        }
        if (this.aggregateImage != null) {
            this.aggregateImage.dispose();
            this.aggregateImage = null;
        }
        this.location = null;
        this.hub = null;
        Enumeration enumeration = this.components.elements();
        while (enumeration.hasMoreElements()) {
            ((LeafCompositeLike)enumeration.nextElement()).dispose();
        }
        this.components.removeAllElements();
    }

    public final void add(LeafCompositeLike leafCompositeLike) {
        if (leafCompositeLike != null) {
            this.components.addElement(leafCompositeLike);
        }
    }

    protected GraphicImage getAggregateImage() {
        return new GraphicImage(this.hub.getBrowser().imageFrom((Object)this, this.gifName), this.location, 2, null, null);
    }

    protected String getAggregateFlyOver() {
        return this.hub.getBundle().getString("Telco");
    }

    protected abstract GraphicImage getLogicalImage();

    protected String getLogicalFlyOver() {
        return this.hub.getBundle().getString("Bank");
    }

    public void draw() {
        this.aggregateImage = this.getAggregateImage();
        if (this.network != 20 && this.network != 3) {
            this.hub.getNetworksWindow().addObjectToNetwork(this.network, this);
        }
        this.aggregateImage.setAction((GraphicAction)this);
        this.aggregateImage.setFlyOver(new GraphicFlyOver(this.getAggregateFlyOver()));
        this.aggregateImage.addPopupMenuItem(this.getAggregateMenuItem());
        this.moduleContainer.add((GraphicComponent)this.aggregateImage);
        GraphicImage graphicImage = this.getLogicalImage();
        graphicImage.setAction((GraphicAction)this);
        graphicImage.setFlyOver(new GraphicFlyOver(this.getLogicalFlyOver()));
        graphicImage.addPopupMenuItem(this.getLogicalMenuItem());
        this.logicalContainer.add((GraphicComponent)graphicImage);
        Enumeration enumeration = this.components.elements();
        while (enumeration.hasMoreElements()) {
            LeafCompositeLike leafCompositeLike = (LeafCompositeLike)enumeration.nextElement();
            leafCompositeLike.draw();
        }
        this.aggregateImage.setStatus(DefaultStatus.getDefaultStatus());
        this.hub.askStatus(this);
        this.moduleContainer.add(this.logicalContainer);
    }

    public final void statusesAttached() {
        CompoundStatus compoundStatus = new CompoundStatus();
        compoundStatus.setManager(new CompStatusDefault());
        Enumeration enumeration = this.components.elements();
        while (enumeration.hasMoreElements()) {
            LeafCompositeLike leafCompositeLike = (LeafCompositeLike)enumeration.nextElement();
            if (!(leafCompositeLike instanceof PortLike) || !(leafCompositeLike instanceof StatusRefLike)) continue;
            compoundStatus.addDependent(((StatusRefLike)((Object)leafCompositeLike)).getStatusRef());
        }
        this.aggregateImage.setStatus((Status)compoundStatus);
    }

    public void discoverChildren() {
    }

    protected final void toggleView() {
        this.logicalContainer.setVisible(!this.isLogicalView);
        this.aggregateImage.setVisible(this.isLogicalView);
        this.isLogicalView = !this.isLogicalView;
    }

    public final void setCommonInformation(HubInfoLike hubInfoLike, int n, int n2, int n3, Point point, GraphicContainer graphicContainer, int n4, int n5, String string, GenModel genModel) {
        this.hub = hubInfoLike;
        this.slot = n;
        this.subSlot = n2;
        this.bankIndex = n3;
        this.location = point;
        this.moduleContainer = graphicContainer;
        this.modType = n4;
        this.network = n5;
        this.destinationPanel = string;
        this.portModel = genModel;
        this.logicalContainer.setVisible(false);
        this.logicalContainer.setLocation(point.x, point.y);
    }

    protected final MenuItem getAggregateMenuItem() {
        MenuItem menuItem = new MenuItem(this.hub.getBundle().getString("Show_logical_view"));
        menuItem.addActionListener(this);
        return menuItem;
    }

    protected final MenuItem getLogicalMenuItem() {
        MenuItem menuItem = new MenuItem(this.hub.getBundle().getString("Show_aggregate_view"));
        menuItem.addActionListener(this);
        return menuItem;
    }

    public final void doAction(GraphicComponent graphicComponent) {
        this.toggleView();
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        this.toggleView();
    }

    public void gray() {
        String string = "gray";
        if (this.aggregateImage.getStatus() != DefaultStatus.getDefaultStatus()) {
            this.aggregateImage.setVisible(false);
            if (RAS.isEnabled(19, 2)) {
                RAS.trace(19, 2, this, string, "Bank grayed: " + this);
            }
        }
    }

    public void ungray() {
        String string = "ungray";
        this.aggregateImage.setVisible(true);
        if (RAS.isEnabled(19, 2)) {
            RAS.trace(19, 2, this, string, "Bank highlighted: " + this);
        }
    }

    public String toString() {
        return "Slot -> " + this.slot + " Sub-slot -> " + this.subSlot + " Bank -> " + this.bankIndex;
    }
}

